
#version 3.0;

/* ------ Include-Dateien -------------- */
#include "colors.inc"
#include "Room.inc"
#include "SpaceShip.inc"

// --------- Konstante Werte --------------------------
#declare Nix        =    0.005

/* ------ Kamera-Definitionen ---------- */

// let the camera flight like a space ship through the atrificial room
camera { //SShip
  location <0,0,0>
  look_at  <1,0,0>
}

/* ------ Licht-Quellen ---------------- */
light_source { <1, 1, -5> color LightGrey}

/* ------ Hintergrund ------------------ */
background {SkyBlue}

/* ------ Objekte ---------------------- */

sphere { //My_Sphere
  < 0, 0, 0 >, 0.45
  pigment {hexagon Yellow, LightWood, OldGold scale 0.1}  
}


// Loch
difference {
  plane {
    -z,0
  }
  box { < 5 - Nix, 4 - Nix, 10  - Nix>, < -5 + Nix, -4 + Nix, - 1  > }
  cylinder { < -4,  3, 0 >, < -4,  3, 50 >, 0.7 pigment{ checker Blue, Magenta} }
  cylinder { < -4, -1, 0 >, < -4, -1, 50 >, 0.7 pigment{ checker Blue, Magenta} }
  pigment {checker Black, White}  
}

// Drei Ringe rechts
object {
  Ring
  translate < 4, -1 , 1 >
  pigment {Red}
}
object {
  Ring
  translate < 4,  0 , 1 >
  pigment {Green}
}
object {
  Ring
  translate < 4,  1 , 1 >
  pigment {Blue}
}
//Kugel hinten oben rechts
sphere {
  < 5, 4, 10 >, 3
  pigment { color Yellow }
  finish {Metallfinish} 
}
//Spiegel hinten unten links
intersection {
  plane {
    < 1, 1, -1 >, 0
    pigment { color Gray60 }
    finish {Metallfinish} 
  }
  box { < -1, -1, -2>,< 2, 2, 1>}
  translate < -4, -3, 9 >
}
// Kurve vorne links
object {
  Ring
  rotate < 90, 180, 0 >
  translate < -4,  -1 , 3 >
  pigment { Cyan }
}
object {
  Ring
  rotate < 0, 180, 0 >
  translate < -4,   1 , 1 >
  pigment { Cyan }
}
object {
  Ring
  rotate < 90, 180, 0 >
  translate < -4,   3 , 3 >
  pigment { Cyan }
}
// Kurvenleitplanken
intersection {
  union {
    torus {
      2, 0.05
      rotate < 0, 0, 90 >
      translate < -4.5, 1, 3 >
    }   
    torus {
      2, 0.05
      rotate < 0, 0, 90 >
      translate < -3.5, 1, 3 >
    }   
    torus {
      2.5, 0.05
      rotate < 0, 0, 90 >
      translate < -4, 1, 3 >
    }   
    torus {
      1.5, 0.05
      rotate < 0, 0, 90 >
      translate < -4, 1, 3 >
    }   
  }
  plane { z, 3 }
  pigment { Cyan }
}
