#ifdef(SpaceShip_Inc_Temp)
/* do nothing */
#else
#declare SpaceShip_Inc_Temp = version;
#version 3.0;

#ifdef(View_POV_Include_Stack)
#   debug "including SpaceShip.inc\n"
#end

#include "colors.inc"
#include "SpaceTextur.inc"

/* --------------------------- Meldung --------------------------------- */
#render "---------------------------------------------------------------\n"
#render "Beginne mit SpaceShip.inc\n"

/*-----------------------------------------------------------------------------------------------------------------------*/
/*-------------------------------------------------     SpaceShip     ---------------------------------------------------*/
/*-----------------------------------------------------------------------------------------------------------------------*/
/*--------------------                  Lnge: 12.5         Hhe: 4          Breite: 9                -------------------*/
/*--------------------                 Nullpunkt: < 5, 1, 4.5 >        Blick-Richtung: "+X"           -------------------*/
/*-----------------------------------------------------------------------------------------------------------------------*/
#declare Faktor = 0.5      /*----------      Vergrerungsfaktor       --------------------------------------------------*/
/*-----------------------------------------------------------------------------------------------------------------------*/
#declare Glass = off       /* ---------     Durchsichtige Scheiben     --------------------------------------------------*/
// ----------------------------------------------------------------------------------------------------------------------*/


/* ------------ SpaceShip-Daten Ausgabe ------------------- */
#switch (Glass)
    #case (on ) #declare Glass_String = " On  " #break
    #case (off) #declare Glass_String = " Off " #break
    #else       #declare Glass_String = str(Glass,20,15)
#end
#render concat(" Raumschiff [ Glass: ", Glass_String, "]\n")



/* ------------------- SpaceShip-Definition ------------------------ */

#declare SpaceShip = object {
union {

intersection {
             sphere { <0,0,0>,1 scale <5,2,3> }                                           // Oben  Vorne  Scheibe
             plane  { -y,-0.5 }
             merge  { cylinder { < 0,  0,-3>,< 0,0,3>,1 scale <1,1.5,1> translate <-2,2,0> }
                      box      { <-5,0.5,-3>,<-2,2,3> } }
             #if (Glass = on)
                 material{ GlasEinfach }
                 /*material{
                     texture {
                         pigment {color rgbf<0.8,1,1,0.8>}
                         finish {
                             specular 0.5 roughness 0.08
                             reflection 0.3
                         }
                     } 
                     interior {
                         ior 1.5
                         caustics 1
                     }
     
                 } */          
                 
             #else
                 pigment {Cyan}
             #end
}
merge {
      difference   { sphere { <0,0,0>,1 scale <5,2,3> }                                     // Oben  Vorne  Rahmen
                     plane  { y,0 }
                     union { cylinder { < 0,  0,-3>,< 0,0,3>,1 scale <1,1.5,1> translate <-2,2,0> }
                             box      { <-5,0.5,-3>,<-2,2,3> } } }
      intersection { torus    { 0.5, 0.5 scale <5,2,3> }                                    // Unten Vorne  Auen
                     plane {  y,  0 } }
      cylinder     { <0,0,   0>,<  0,-0.5,   0>,0.5 scale <5,2,3> }                         // Unten Vorne  Innen
      intersection { cylinder { <0,0,0>,< 6,0,0>,1 scale <1,2,3> }                          // Oben  Mitte
                     plane { -y,  0 } }
      cylinder     { <0,0, 0.5>,<  6,   0, 0.5>,0.5 scale <1,2,3> }                         // Unten Mitte  Rechts
      cylinder     { <0,0,-0.5>,<  6,   0,-0.5>,0.5 scale <1,2,3> }                         // Unten Mitte  Links
      box          { <0,0,-1.5>,<  6,  -1, 1.5> }                                           // Unten Mitte  Mitte
      intersection { torus    { 0.5,0.5 rotate <0,0,90> scale <3,2,3> translate <6,0,0> }   // Oben  Hinten Auen
                     plane { -y,0 } }
      intersection { cylinder { <6,0,0>,<7.5,0,0>,0.5 scale <1,2,3> }                       // Oben  Hinten Innen
                     plane { -y,0 } }
      sphere       { <0,0, 0.5>,0.5                 scale <3,2,3> translate <6,0,0> }       // Unten Hinten Rechts
      sphere       { <0,0,-0.5>,0.5                 scale <3,2,3> translate <6,0,0> }       // Unten Hinten Links
      cylinder     { <0,0,-1.5>,<  0,   0, 1.5>,0.5 scale <3,2,1> translate <6,0,0> }       // Unten Hinten Mitte
      pigment {Blue}
}
merge {
      intersection { box          { <0,0.4, 2.5>,<6,0.6, 4.5> }                            // Flgel Rechts
                     plane        { <-1,0, 3>,2.7 } }
      intersection { box          { <0,0.4,-2.5>,<6,0.6,-4.5> }                            // Flgel Links                    plane        { <-1,2,0>,0.5 } }
                     plane        { <-1,0,-3>,2.7 } }
      intersection { box          { <0,1.5,-0.1>,<6,  3, 0.1> }                            // Flgel Oben
                     plane        { <-1,2, 0>,0.5 } }
      pigment {Magenta}
}
scale < -Faktor, Faktor, Faktor>

}
}

/* ------------------- SpaceShip-Definition Ende ------------------- */


/* ------ Meldung ---------------------- */
#render "SpaceShip.inc beendet\n"


#version SpaceShip_Inc_Temp;
#end



//----ERROR---->ALL RIGHT<----              No objects in scene?
